﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.Instructor
{
    public partial class UCInstructorDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<BL.BO.Instructor, BL.BO.Instructor.Search>
    {
        private const int _IndexTabInstructor = 0;
        protected     int _IndexTabSystemInformation        = 1;
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabInstructorDetails _tabSchoolDetails = null;

        public UCTabInstructorDetails TabInstructorDetails
        {
            get
            {
                if (_tabSchoolDetails == null)
                {
                    _tabSchoolDetails = new UCTabInstructorDetails();
                }
                return _tabSchoolDetails;
            }
        }

        internal PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCInstructorDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();
            MinimumHorizontalSize = 400;
            MinimumVerticalSize = 190;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabInstructor, TabInstructorDetails, "Ustawienia");
            this.AddControlAtTab(_IndexTabSystemInformation     , TabSystemInformation      , "Informacje systemowe");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabInstructorDetails.Initialize(this, Environment, ParentPlugIn);
            TabSystemInformation.Initialize(this, Environment, ParentPlugIn);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            TabInstructorDetails.Save();
            _methodResult = BLZSBELearning.Instructor.Save(DataManager.Current);

            return _methodResult;
        }

        protected override bool DoRestore(long? ID)
        {
            bool _result = false;
            BL.BO.Instructor _Instructor = BLZSBELearning.Instructor.Restore(ID);
            if (_Instructor != null)
            {
                _result = true;
                DataManager.LoadData(null, null, _Instructor);
                TabInstructorDetails.Restore();

                this.CreateToolbarActions();
            }

            return _result;
        }

        protected override Gemini.Core.BL.Base.MethodResult DoRemove()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            if(DataManager.Current != null)
            {
                List<BL.BO.Student> _listStudent = BLZSBELearning.Student.Restore(DataManager.Current);
                List<BL.BO.Class> _listClass = BLZSBELearning.Class.Restore(DataManager.Current);

                ProcessStart(ProcessingType.Remove, _listStudent.Count + _listClass.Count + 1);

                foreach (BL.BO.Student _loopStudent in _listStudent)
                {
                    _methodResult.Add(BLZSBELearning.Student.Remove(_loopStudent));
                    Process();
                }

                foreach (BL.BO.Class _loopClass in _listClass)
                {
                    _methodResult.Add(BLZSBELearning.Class.Remove(_loopClass));
                    Process();
                }

                if (_methodResult.Success == true)
                {
                    _methodResult.Add(BLZSBELearning.Instructor.Remove(DataManager.Current));
                }

                Process();
            }
            return _methodResult;
        }

        protected override bool DoConfirmDelete()
        {
            bool _return = false;

            if (DataManager.Current != null)
            {
                FRemoveInstructor _dialog = Gemini.Core.WinForms.Base.Form.Create<FRemoveInstructor>(this.Plugin, Environment);
                _dialog.Initialize(DataManager.Current, Plugin, Environment);

                if (DialogResult.OK == _dialog.ShowDialog())
                {
                    _return = true;
                }
                else
                {
                    _return = false;
                }
            }
            return _return;
        }
    }
}
